using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Runtime.InteropServices;

namespace Hello
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class Form1 : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Panel panel1;
		private System.Windows.Forms.Button button1;
		private System.Timers.Timer timer1;
		private Ball[] balls;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public Form1()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
			balls = new Ball[]{
				new Ball(50, 10,  10,  0, 10, .9f, Color.Black, panel1.Width, panel1.Height),
				new Ball(30, 30,  30,  0, 10, .8f, Color.Red, panel1.Width, panel1.Height),
				new Ball(10, 50,  50, 30, 10, .7f, Color.Blue, panel1.Width, panel1.Height),
				new Ball(20, 70,  10,  0, 10, .85f, Color.Green, panel1.Width, panel1.Height)
			};

		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.panel1 = new System.Windows.Forms.Panel();
			this.button1 = new System.Windows.Forms.Button();
			this.timer1 = new System.Timers.Timer();
			((System.ComponentModel.ISupportInitialize)(this.timer1)).BeginInit();
			this.SuspendLayout();
			// 
			// panel1
			// 
			this.panel1.BackColor = System.Drawing.Color.White;
			this.panel1.Location = new System.Drawing.Point(16, 16);
			this.panel1.Name = "panel1";
			this.panel1.Size = new System.Drawing.Size(632, 384);
			this.panel1.TabIndex = 0;
			this.panel1.Paint += new System.Windows.Forms.PaintEventHandler(this.panel1_Paint);
			// 
			// button1
			// 
			this.button1.Location = new System.Drawing.Point(272, 408);
			this.button1.Name = "button1";
			this.button1.TabIndex = 1;
			this.button1.Text = "Exit";
			this.button1.Click += new System.EventHandler(this.button1_Click);
			// 
			// timer1
			// 
			this.timer1.Enabled = true;
			this.timer1.Interval = 10;
			this.timer1.SynchronizingObject = this;
			this.timer1.Elapsed += new System.Timers.ElapsedEventHandler(this.timer1_Elapsed);
			// 
			// Form1
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(656, 437);
			this.Controls.Add(this.button1);
			this.Controls.Add(this.panel1);
			this.Name = "Form1";
			this.Text = "Form1";
			this.Load += new System.EventHandler(this.Form1_Load);
			((System.ComponentModel.ISupportInitialize)(this.timer1)).EndInit();
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}

		private void Form1_Load(object sender, System.EventArgs e)
		{
		
		}

		private void Form1_Paint(object sender, PaintEventArgs e)
		{

		}

		private void panel1_Paint(object sender, System.Windows.Forms.PaintEventArgs e)
		{
			Console.WriteLine("Paint is called");
			Graphics g = e.Graphics;
			foreach (Ball b in balls) b.show(g);
		}

		private void timer1_Elapsed(object sender, System.Timers.ElapsedEventArgs e)
		{
			foreach (Ball b in balls)
			{
				b.move((float)timer1.Interval/100);
			}
			panel1.Refresh();
			balls[0].ss(balls[3]);
		}

		private void button1_Click(object sender, System.EventArgs e)
		{
			Application.Exit();
		}
	}

	public class Ball
	{
		private float x,y;
		private float gravity;
		private Color color;
		private float vx, vy;
		private Brush brush;
		private float bx, by;
		public float elastic;
		public int   size;

		public Ball(float x, float y, float vx, float vy, float g, float e, Color c, float bx, float by)
		{
			this.x = x;
			this.y = y;
			this.gravity = g;
			this.color = c;
			this.vx = vx;
			this.vy = vy;
			this.bx = bx;
			this.by = by;
			this.brush = new SolidBrush(c);
			this.elastic = e;
			this.size    = 7;
		}

		public void move(float t)
		{
			x  += vx*t;
			vy += gravity*t;
			y  += vy*t;

			if (x-size < 0 || x+size > bx)
			{
				vx = -vx*elastic;
				if (Math.Abs(vx) > 5) API.Beep(500+(int)(Math.Abs(vx)*10),20);
			}

			if (y-size < 0 || y+size > by)
			{
				vy = -vy*elastic;
				if (Math.Abs(vy) > 5) API.Beep(500+(int)(Math.Abs(vy)*10),20);
			}

			if (x-size < 0)  x = size;
			if (x+size > bx) x = bx-size;
			if (y-size < 0)  y = size;
			if (y+size > by) y = by-size;
		}

		public void ss(Ball b)
		{
			b.bx = 30;
		}

		public void show(Graphics g)
		{
			g.FillEllipse(brush, x-size, y-size, size*2, size*2);
		}
	}

	public sealed class API
	{
		private API() {}
		
		[DllImport("kernel32")]
		public static extern bool Beep( int freq, int dur );
	}
}
