﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace ButtonChase
{
   public partial class Form1 : Form
   {
      Random rand;
      int count;
      int remain;

      public Form1()
      {
         InitializeComponent();
         rand = new Random();
         prepare();
      }

      void prepare()
      {
         count = 0;
         remain = 10000;
         mainButton.Text = count.ToString();
         timeRemain.Text = "Click the button 20 times before time runs out.";
      }

      private void mainButton_Click(object sender, EventArgs e)
      {
         if (count == 0) timer.Enabled = true;

         mainButton.Width = rand.Next(50, 200);
         mainButton.Height = rand.Next(30, 200);
         mainButton.Left = rand.Next(this.Width - mainButton.Width);
         mainButton.Top = rand.Next(this.Height - mainButton.Height - 50);
         count++;
         mainButton.Text = count.ToString();
         if (count >= 20)
         {
            timer.Enabled = false;
            MessageBox.Show("You win!");
            prepare();
         }
      }

      private void timer_Tick(object sender, EventArgs e)
      {
         remain -= timer.Interval;
         timeRemain.Text = String.Format("Time remaining: {0:f1}", remain/1000.0);
         if (remain <= 0)
         {
            timer.Enabled = false;
            MessageBox.Show("You lose!");
            prepare();
         }
      }
   }
}
